<?php
/*
Plugin Name: Wpis bloga typu kolekcja muzyczna
Plugin URI: http://przyklad.pl
Description: Utworzenie własnego typu wpisu bloga o nazwie music_album.
Version: 0.1
Author: WROX
Author URI: http://wrox.com
*/

/* Konfiguracja typu wpisu bloga. */
add_action( 'init', 'boj_music_collection_register_post_types' );

/* Rejestracja typu wpisu bloga. */
function boj_music_collection_register_post_types() {

    /* Ustawienie argumentów dla typu wpisu bloga music_album. */
    $album_args = array(
        'public' => true,
        'query_var' => 'music_album',
        'rewrite' => array(
            'slug' => 'music/albums',
            'with_front' => false,
        ),
        'supports' => array(
            'title',
            'thumbnail'
        ),
        'labels' => array(
            'name' => 'Albumy',
            'singular_name' => 'Album',
            'add_new' => 'Dodaj nowy album',
            'add_new_item' => 'Dodaj nowy album',
            'edit_item' => 'Edytuj album',
            'new_item' => 'Nowy album',
            'view_item' => 'Wyświetl album',
            'search_items' => 'Szukaj w albumach',
            'not_found' => 'Nie znaleziono albumów',
            'not_found_in_trash' => 'Nie znaleziono albumów w koszu'
        ),
    );

    /* Rejestracja typu wpisu bloga music_album. */
    register_post_type( 'music_album', $album_args );
}

?>
