<?php
/*
Plugin Name: Przykład skrótu nr 3
Plugin URI: http://przyklad.pl/
Description: Zastępuje znacznik [amazon isbn="xxx"]tytul ksiazki[/amazon].
Version: 1.0
Author: Ozh
Author URI: http://wrox.com/
*/

// Rejestracja nowego skrótu: [amazon isbn="123"]tytul ksiazki[/amazon].
add_shortcode( 'amazon', 'boj_sc3_amazon' );

// Funkcja wywoływana w celu zastąpienia znacznika [amazon].
function boj_sc3_amazon( $attr, $content ) {
    
    // Pobranie numeru ISBN lub ustawienie domyślnego.
    if( isset( $attr['isbn'] ) ) {
        $isbn = preg_replace( '/[^\d]/', '', $attr['isbn'] );
    } else {
        $isbn = '0470560541';
    }
    
    // Oczyszczenie treści lub ustawienie domyślnej.
    if( !empty( $content ) ) {
        $content = esc_html( $content );
    } else {
        if( $isbn == '0470560541' ) {
            $content = 'Professional WordPress';
        } else {
            $content = 'ta książka';
        }
    }
    
    return "<a href='http://www.amazon.com/dp/$isbn'>$content</a>";
}

