<?php
/*
Plugin Name: Treść prywatna
Plugin URI: http://przyklad.pl
Description: Skrót pozwalający na ukrycie treści prywatnej.
Version: 0.1
Author: WROX
Author URI: http://wrox.com
*/

/* Zarejestrowanie skrótu w zaczepie akcji init. */
add_action( 'init', 'boj_private_content_register_shortcodes' );

/* Funkcja rejestrująca skrót. */
function boj_private_content_register_shortcodes() {

    /* Dodanie skrótu [boj-private]. */
    add_shortcode( 'boj-private', 'boj_private_content_shortcode' );
}

/* Funkcja obsługująca dane wyjściowe skrótu. */
function boj_private_content_shortcode( $attr, $content = null ) {

    /* Jeżeli nie ma żadnej treści, zakończ działanie. */
    if ( is_null( $content ) )
        return $content;

    /* Sprawdzenie, czy bieżący użytkownik ma możliwość read_private_content. */
    if ( current_user_can( 'read_private_content' ) ) {

        /* Wygenerowanie treści prywatnej. */
        return $content;
    }

    /* Jeżeli użytkownik nie ma możliwości read_private_content. */
    else {

        /* Wyświetlenie komunikatu alternatywnego. */
        return '<p>Nie masz uprawnień do przeglądania tej treści.</p>';
    }

    /* Zwrócenie pustego ciągu tekstowego. */
    return '';
}

?>
