<?php

add_filter( 'the_content', 'boj_add_related_posts_to_content' );

function boj_add_related_posts_to_content( $content ) {

    /* Jeeli nie jest wywietlany pojedynczy wpis bloga, wystarczy po prostu zwrci tre. */
    if ( !is_singular( 'post' ) )
        return $content;
		
		/* Pobranie kategorii biecego wpisu bloga. */
    $terms = get_the_terms( get_the_ID(), 'category' );
		
		/* Iteracja przez kategorie i umieszczenie ich identyfikatorw w tablicy. */
    $categories = array();
    foreach ( $terms as $term )
        $categories[] = $term->term_id;
		
		/* Wyszukanie w bazie danych wpisw bloga zaliczanych do tych samych kategorii. */
    $loop = new WP_Query(
        array(
            'cat__in' => $categories,
            'posts_per_page' => 5,
            'post__not_in' => array( get_the_ID() ),
            'orderby' => 'rand'
        )
    );
		
		/* Sprawdzenie istnienia wpisw bloga powizanych z aktualnie wywietlanym. */
    if ( $loop-> have_posts() ) {
						
				/* Pocztek nieuporzdkowanej listy. */
        $content .= '<ul class="related-posts">';
        while ( $loop->have_posts() ) {
            $loop->the_post();
						
						/* Dodanie tytuu wpisu bloga wraz z odnonikiem do niego. */
            $content .= the_title(
                '<li><a href="' . get_permalink() . '">',
                '</a></li>',
                false
            );
        }
				
				/* Koniec nieuporzdkowanej listy. */
        $content .= '</ul>';
				
				/* Wyzerowanie zapytania. */
        wp_reset_query();
    }
		
		/* Zwrot treci. */
    return $content;
}

?>
