<?php 
/*
Plugin Name: Przykład wtyczki tworzącej pole użytkownika
Plugin URI: http://przyklad.pl/wtyczki-wordpresss/moja-wtyczka
Description: Wtyczka służąca do tworzenia pola użytkownika na platformie WordPress 
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

// Zaczep wykorzystywany podczas tworzenia pola użytkownika.
add_action( 'add_meta_boxes', 'boj_mbe_image_create' );

function boj_mbe_image_create() {

	// Utworzenie własnego pola użytkownika.
	add_meta_box( 'boj-image-meta', 'Wybierz obraz', 'boj_mbe_image_function', 'post', 'normal', 'high' );
	
}

function boj_mbe_image_function( $post ) {

	// Pobranie wartości metadanych, o ile istnieją.
	$boj_mbe_image = get_post_meta( $post->ID, '_boj_mbe_image', true );
	?>
    Obraz <input id="boj_mbe_image" type="text" size="75" name="boj_mbe_image" value="<?php echo esc_url( $boj_mbe_image ); ?>" />
    	  <input id="upload_image_button" type="button" value="Obraz z biblioteki multimediów" class="button-secondary"  />
    <p>Podaj adres URL obrazu lub użyj obrazu z biblioteki multimediów</p>
	<?php
}

// Zaczep do dodawania skryptu wraz z wykrywaniem strony.
add_action('admin_print_scripts-post.php', 'boj_mbe_image_admin_scripts');
add_action('admin_print_scripts-post-new.php', 'boj_mbe_image_admin_scripts');

function boj_mbe_image_admin_scripts() {
	wp_enqueue_script( 'boj-image-upload', plugins_url( '/boj-meta-box/boj-meta-image.js' ), array( 'jquery','media-upload','thickbox' ) );
}

// Zaczep do dodawania stylów wraz z wykrywaniem strony.
add_action('admin_print_styles-post.php', 'boj_mbe_image_admin_styles');
add_action('admin_print_styles-post-new.php', 'boj_mbe_image_admin_styles');

function boj_mbe_image_admin_styles() {
	wp_enqueue_style( 'thickbox' );
}

// Zaczep pozwalający na zapis danych pola użytkownika.
add_action( 'save_post', 'boj_mbe_image_save_meta' );

function boj_mbe_image_save_meta( $post_id ) {

	// Sprawdzenie, czy metadane zostały podane.
	if ( isset( $_POST['boj_mbe_image'] ) ) {
	
		// Zapis metadanych.
		update_post_meta( $post_id, '_boj_mbe_image', esc_url_raw( $_POST['boj_mbe_image'] ) );

	}

}
?>
