import React from 'react';
import { useQuery } from '@apollo/client';

import NoteFeed from '../components/NoteFeed';
import Button from '../components/Button';
import { GET_NOTES } from '../gql/query';

const Home = () => {
  // Zaczep zapytania.
  const { data, loading, error, fetchMore } = useQuery(GET_NOTES);

  // Jeżeli dane są wczytywane, należy wyświetlić odpowiedni komunikat.
  if (loading) return <p>Wczytywanie...</p>;
  // Jeżeli podczas pobierania danych wystąpi błąd, należy wyświetlić komunikat błędu.
  if (error) return <p>Błąd!</p>;

  // Jeżeli pobranie danych zakończyło się sukcesem, należy je wyświetlić w interfejsie użytkownika.
  return (
    <React.Fragment>
      <NoteFeed notes={data.noteFeed.notes} />
      {data.noteFeed.hasNextPage && (
        <Button
          onClick={() =>
            fetchMore({
              variables: {
                cursor: data.noteFeed.cursor
              },
              updateQuery: (previousResult, { fetchMoreResult }) => {
                return {
                  noteFeed: {
                    cursor: fetchMoreResult.noteFeed.cursor,
                    hasNextPage: fetchMoreResult.noteFeed.hasNextPage,
                    // Dołączenie nowych danych do już znajdujących się na stronie.
                    notes: [
                      ...previousResult.noteFeed.notes,
                      ...fetchMoreResult.noteFeed.notes
                    ],
                    __typename: 'noteFeed'
                  }
                };
              }
            })
          }
        >
          Więcej
        </Button>
      )}
    </React.Fragment>
  );
};

export default Home;
