import React from 'react';
import { Text, View } from 'react-native';
import { useQuery, gql } from '@apollo/client';

import NoteFeed from '../components/NoteFeed';
import Loading from '../components/Loading';

// Nasze zapytanie GraphQL.
const GET_MY_FAVORITES = gql`
  query me {
    me {
      id
      username
      favorites {
        id
        createdAt
        content
        favoriteCount
        author {
          username
          id
          avatar
        }
      }
    }
  }
`;

const Favorites = props => {
  const { loading, error, data } = useQuery(GET_MY_FAVORITES);

  // Jeżeli dane są wczytywane, należy wyświetlić odpowiedni komunikat.
  if (loading) return <Loading />;
  // Jeżeli podczas pobierania danych wystąpi błąd, należy wyświetlić komunikat błędu.
  if (error) return <Text>Błąd podczas pobierania notatek.</Text>;
  // Jeżeli wykonanie zapytania zakończyło się sukcesem i są notatki, należy zwrócić kanał notatek.
  // Natomiast jeżeli wykonanie zapytania zakończyło się sukcesem, ale nie ma notatek, należy wyświetlić odpowiedni komunikat.
  if (data.me.favorites.length !== 0) {
    return <NoteFeed notes={data.me.favorites} navigation={props.navigation} />;
  } else {
    return <Text>Nie ma jeszcze żadnych notatek.</Text>;
  }
};

Favorites.navigationOptions = {
  title: 'Ulubione'
};

export default Favorites;
