import React from 'react';
import { Text, ScrollView } from 'react-native';
import styled from 'styled-components/native';
import Markdown from 'react-native-markdown-renderer';
import { format } from 'date-fns';

const NoteView = styled.ScrollView`
  padding: 10px;
`;

const Note = ({ note }) => {
  return (
    <NoteView>
      <Text>
        Notatka utworzona przez {note.author.username} / opublikowana{' '}
        {format(new Date(note.createdAt), 'Do MMM YYYY')}
      </Text>
      <Markdown>{note.content}</Markdown>
    </NoteView>
  );
};

export default Note;
