import React from 'react';
import { View, Button, Text } from 'react-native';
import * as SecureStore from 'expo-secure-store';
import { useMutation, gql } from '@apollo/client';

import UserForm from '../components/UserForm';
import Loading from '../components/Loading';

const SIGNUP_USER = gql`
  mutation signUp($email: String!, $username: String!, $password: String!) {
    signUp(email: $email, username: $username, password: $password)
  }
`;

const SignUp = props => {
  const [signUp, { loading, error }] = useMutation(SIGNUP_USER, {
    onCompleted: data => {
      // Przechowywanie tokena z kluczem o wartości 'token'.
      // Po zapisaniu tokena, należy przenieść użytkownika do ekranu głównego aplikacji.
      SecureStore.setItemAsync('token', data.signUp).then(
        props.navigation.navigate('App')
      );
    }
  });

  // Jeżeli dane są wczytywane, trzeba o tym poinformować użytkownika.
  if (loading) return <Loading />;

  return (
    <React.Fragment>
      {error && <Text>Błąd podczas uwierzytelniania!</Text>}
      <UserForm
        action={signUp}
        formType="signUp"
        navigation={props.navigation}
      />
    </React.Fragment>
  );
};

SignUp.navigationOptions = {
  title: 'Rejestracja'
};

export default SignUp;
