import React from 'react';
import { useMutation, useQuery } from '@apollo/client';

// Import komponentu Note.
import NoteForm from '../components/NoteForm';
import { GET_NOTE, GET_ME } from '../gql/query';
import { EDIT_NOTE } from '../gql/mutation';

const EditNote = props => {
  // Identyfikator z adresu URL jest przechowywany w zmiennej.
  const id = props.match.params.id;
  // Zdefiniowanie zapytania.
  const { loading, error, data } = useQuery(GET_NOTE, { variables: { id } });
  const { data: userdata } = useQuery(GET_ME);
  // Zdefiniowanie mutacji.
  const [editNote] = useMutation(EDIT_NOTE, {
    variables: {
      id
    },
    onCompleted: () => {
      props.history.push(`/note/${id}`);
    }
  });

  // Jeżeli dane są wczytywane, należy wyświetlić odpowiedni komunikat.
  if (loading) return 'Wczytywanie...';
  // Jeżeli podczas pobierania danych wystąpi błąd, należy wyświetlić komunikat błędu.
  if (error) return <p>Błąd!</p>;
  // Jeżeli bieżący użytkownik nie jest autorem notatki, trzeba wyświetlić odpowiedni komunikat.
  if (userdata.me.id !== data.note.author.id) {
    return <p>Nie możesz edytować tej notatki.</p>;
  }

  // Przekazanie danych do komponentu formularza.
  return <NoteForm content={data.note.content} action={editNote} />;
};

export default EditNote;
