import React from 'react';
import Screens from './screens';
// Import bibliotek Apollo.
import {
  ApolloClient,
  ApolloProvider,
  createHttpLink,
  InMemoryCache
} from '@apollo/client';
import { setContext } from 'apollo-link-context';
// Import SecureStore w celu pobrania wartości tokena.
import * as SecureStore from 'expo-secure-store';

// Import konfiguracji środowiska.
import getEnvVars from '../config';
const { API_URI } = getEnvVars();

// Konfiguracja adresu URI naszego API i bufora.
const uri = API_URI;
const cache = new InMemoryCache();
const httpLink = createHttpLink({ uri });

// Sprawdzenie tokena i zwrot nagłówków do kontekstu.
const authLink = setContext(async (_, { headers }) => {
  return {
    headers: {
      ...headers,
      authorization: (await SecureStore.getItemAsync('token')) || ''
    }
  };
});

// Konfiguracja klienta Apollo.
const client = new ApolloClient({
  link: authLink.concat(httpLink),
  cache
});

const Main = () => {
  // Opakowanie aplikacji komponentem wyższego rzędu ApolloProvider.
  return (
    <ApolloProvider client={client}>
      <Screens />
    </ApolloProvider>
  );
};

export default Main;
