import React from 'react';
import Screens from './screens';
// Import bibliotek Apollo.
import { ApolloClient, ApolloProvider, InMemoryCache } from '@apollo/client';
// Import konfiguracji środowiska.
import getEnvVars from '../config';
const { API_URI } = getEnvVars();

// Konfiguracja adresu URI naszego API i bufora.
const uri = API_URI;
const cache = new InMemoryCache();

// Konfiguracja klienta Apollo.
const client = new ApolloClient({
  uri,
  cache
});

const Main = () => {
  // Opakowanie aplikacji komponentem wyższego rzędu ApolloProvider.
  return (
    <ApolloProvider client={client}>
      <Screens />
    </ApolloProvider>
  );
};

export default Main;
