/************************************************************
 *             Gomoku ("Kko i Krzyyk")                   *
 *           Copyright (c) Adam Boduch 2006                 *
 *              E-mail: adam@boduch.net                     *
 *              http://4programmers.net                     *
 *                                                          *
 * *********************************************************/
using System;

class Program
{
    // instancja klasy
    static GomokuEngine GomokuObj;

    // metoda wywietla informacje o autorze
    static void About()
    {
        Console.WriteLine(
        "   Kko i Krzyyk v. 1.0          \n" +
        "   Copyrigh (c) Adam Boduch 2006   \n" +
        "   E-mail: adam@boduch.net         \n");
        Console.ReadLine();
    }

    // metoda wywietla menu gry
    static void Menu()
    {
        Console.Clear();
        Console.WriteLine("------- Kko i krzyyk ------");
        Console.WriteLine("------------------------------");
        Console.WriteLine(" 1 -- Start gry               ");
        Console.WriteLine(" 2 -- Opcje                   ");
        Console.WriteLine(" 3 -- O programie             ");
        Console.WriteLine(" Esc -- Zakoczenie           ");
        Console.WriteLine("------------------------------");
    }

    // gwna metoda - rozpoczecie gry
    static void Start()
    {
        // jeeli uytkownik nie poda imion - przekierowujemy do metody Option
        if (GomokuObj.Player1 == null || GomokuObj.Player2 == null)
        {
            Option();
        }
        // inicjalizacja gry
        GomokuObj.Start();
        // licznik tur
        int Counter = 1;

        Console.WriteLine();

        int X, Y;
        char C;

        // gra bdzie kontynuowana dopki kto nie wygra 
        // warunkiem zakoczenia jest rwniesz remis
        while (GomokuObj.Winner == false)
        {
            Console.WriteLine("Tura nr " + Convert.ToString(Counter) + ". Gracz: " + GomokuObj.Active.Name);
            
            // pobranie wsprzdnych pola
            Console.Write("Podaj wsprzdn Y: ");
            X = Convert.ToInt32(Console.ReadLine());
            Console.Write("Podaj wsprzdn X: ");
            Y = Convert.ToInt32(Console.ReadLine());

            // jeeli nie mona umieci znaku na polu - nie wykonujemy dalszego kodu
            // przechodzimy do kolejnej iteracji
            if (!GomokuObj.Set(X, Y))
            {
                continue;
            }
        
            Counter++;

            // jeeli jest to 9 ruch, widocznie jest remis - przerywamy ptle
            if (Counter == 9)
            {
                break;
            }

            // ponisze ptle maj za zadanie rysowanie planszy do gry
            for (int i = 0; i < 3; i++)
            {
                for (int j = 0; j < 3; j++)
                {
                    switch (GomokuObj.Field[i, j])
                    {
                        case FieldType.ftCross:

                            C = 'X';
                            break;

                        case FieldType.ftCircle:

                            C = 'O';
                            break;

                        default:
                            C = '_';
                            break;
                    }
                    Console.Write(" {0} |", C);
                }
                Console.WriteLine();
            }

        }

        if (GomokuObj.Winner)
        {
            Console.WriteLine("Gratulacje, wygra gracz " + GomokuObj.Active.Name);
        }
        else
        {
            Console.WriteLine("Remis!");
        }
        Console.WriteLine("Nacinij Enter, aby powrci do menu");
        Console.ReadLine();
    }

    // wywietlanie opcji do gry, czyli moliwoci wpisania imion
    static void Option()
    {
        Console.Write("Podaj imi pierwszego gracza: ");
        GomokuObj.Player1 = Console.ReadLine();

        Console.Write("Podaj imi drugiego gracza: ");
        GomokuObj.Player2 = Console.ReadLine();
    }

    static void Main(string[] args)
    {
        // utworzenie nowej instancji klasy
        GomokuObj = new GomokuEngine();

        ConsoleKeyInfo Key;       

        do
        {
            Menu();
            // pobranie wcinitego klawisza
            Key = Console.ReadKey(true);

            // w zalenoci od wcinitego klawisza, wykonujemy okrelon metod
            switch (Key.KeyChar)
            {
                case '1':

                    Start();
                    break;

                case '2':

                    Option();
                    break;

                case '3':

                    About();
                    break;

                case '4':
                    break;
            }
        }
        while (Key.Key != ConsoleKey.Escape);        
    }
}

