/************************************************************
 *             Gomoku ("Kko i Krzyyk")                   *
 *           Copyright (c) Adam Boduch 2006                 *
 *              E-mail: adam@boduch.net                     *
 *              http://4programmers.net                     *
 *                                                          *
 * *********************************************************/
using System;

// typ pola (kko - circle lub krzyyk (cross)
public enum FieldType {ftCircle = 1, ftCross = 10};

// struktura opisujca gracza
public struct Player
{
    // nazwa gracza
    public string Name;
    // ilo zwycistw
    public int Winnings;
    // symbol go reprezentujcy
    public FieldType Type;
}

class GomokuEngine
{
    // tablica 3x3 reprezentujca pole gry
    private FieldType[,] FField = new FieldType[3, 3];
    // zmienna oznaczajca zwycistwo ktrego gracza (true)
    private bool FWinner;
    // ID gracza ktry teraz wykonuje ruch
    private int FActive;
    // tablica graczy (tylko dwch graczy)
    private Player[] FPlayer = new Player[2];

    /* METODY PRYWATNE */
    private string GetPlayer1()
    {
        return FPlayer[0].Name;
    }

    private void SetPlayer1(string Name)
    {
        FPlayer[0].Name = Name;
    }

    private string GetPlayer2()
    {
        return FPlayer[1].Name;
    }

    private void SetPlayer2(string Name)
    {
        FPlayer[1].Name = Name;
    }

    private Player GetActive()
    {
        return FPlayer[FActive];
    }

    // waciwo Winner
    public bool Winner
    {
        get
        {
            return FWinner;
        }
    }
    // waciwo zwraca aktywnego grcza
    public Player Active
    {
        get
        {
            return GetActive();
        }
    }
    // zwraca informacje o graczu nr 1
    public string Player1
    {
        get
        {
            return GetPlayer1();
        }
        set
        {
            SetPlayer1(value);
        }
    }
    // waciwo zwraca informacje o graczu 2
    public string Player2
    {
        get
        {
            return GetPlayer2();
        }
        set
        {
            SetPlayer2(value);
        }
    }
    // waciwo tylko do odczytu, zwraca informacje o polu bitwy ;-)
    public FieldType[,] Field
    {
        get
        {
            return FField;
        }
    }

    // metoda sprawdza czy gracz nr 1 lub 2, wygra gre
    private void Sum(int Value)
    {
        if (Value == 3 || Value == 30)
        {
            FPlayer[FActive].Winnings++;
            FWinner = true;
        }
    }

    // algorytm sprawdza czy ktry z graczy wygra gre
    private void CheckWinner()
    {
        for (int i = 0; i < 3; i++)
        {
            Sum((int)FField[i, 0] + (int)FField[i, 1] + (int)FField[i, 2]);
            Sum((int)FField[0, i] + (int)FField[1, i] + (int)FField[2, i]);
        }

        Sum((int)FField[0, 0] + (int)FField[1, 1] + (int)FField[2, 2]);
        Sum((int)FField[0, 2] + (int)FField[1, 0] + (int)FField[2, 0]);
    }    

    /* rozpoczyna waciw gr */
    public void Start()
    {
        // przyporzdkowanie symbolu danemu graczowi
        FPlayer[0].Type = FieldType.ftCircle;
        FPlayer[1].Type = FieldType.ftCross;

        FWinner = false;
        // czyszczenie tablicy 
        System.Array.Clear(FField, 0, FField.Length);
    }

    // nowa gra - ilo zwycistw zostaje wyzerowana
    public void NewGame()
    {
        FPlayer[0].Winnings = 0;
        FPlayer[1].Winnings = 0;
    }

    // Metoda suy do ustawiania symbolu na danym polu
    public bool Set(int X, int Y)
    {
        // poniewa indeks tablic rozpoczyna si od zera, naley zmniejszy 
        // wartoci wsprzdnych bo user podaje wsprzdne numerowane od 1
        --X;
        --Y;

        // sprawdzenie czy pole nie jest zajte
        if (FField[X, Y] > 0)
        {
            Console.WriteLine("To pola nie jest puste!");
            return false;
        }
        // sprawdzamy czy uytkownik poda prawidowe wsprzdne
        if ((X > 3) || (Y > 3))
        {
            Console.WriteLine("Nieprawidowe wartoci X lub/i Y");
            return false;
        }
        // ustawienie znaku na danym polu
        FField[X, Y] = GetActive().Type;
        // sprawdzenie czy naley zakoczy gr?
        CheckWinner();

        // jeeli nikt nie wygra - zamiana graczy
        if (!Winner)
        {
            FActive = (FActive == 0 ? 1 : 0);
        }
        return true;
    }
}