package {
	import flash.display.Sprite;	
	import flash.events.Event;
	
	public class BouncingBallRecycled extends Sprite {
		private var g:Number=0.1; // przyśpieszenie grawitacyjne
		private var vx:Number;  // początkowa pozioma składowa prędkości
		private var vy:Number;  // początkowa pionowa składowa prędkości
		private var ball:Ball;

		public function BouncingBallRecycled() {
			init();
		}
		private function init():void {		
			ball = new Ball();
			setInitialConditions(); // move initialisation code to a separate function
			addChild(ball);	
			addEventListener(Event.ENTER_FRAME,onEachTimestep); 
		}
		
		private function setInitialConditions():void{ // initialise ball's position and velocity 
			vx = Math.random()*5;
			vy = (Math.random()-0.5)*4;
			ball.x = 50;
			ball.y = 75;
		}

		private function onEachTimestep(evt:Event):void{

			vy += g;      // grawitacja zwiększa pionową składową prędkości
			
			ball.x += vx; // prędkość pozioma zwiększa przemieszczenie ciała w poziomie
			ball.y += vy; // prędkość pionowa zwiększa przemieszczenie ciała w pionie
			
			if (ball.y > 350){ // w przypadku zderzenia z podłożem
				vy *= -0.8;    // wektor prędkości pionowej ulega odwróceniu i skróceniu
			};
			if (ball.x > 550 + ball.width/2){ // take into account ball's width as it exits from right hand side
				setInitialConditions(); // recycle ball
			}

		}
	}
}





