﻿package com.physicscodes.objects {
	import flash.display.GradientType;
	import flash.display.Sprite;
	import flash.geom.Matrix;
	import com.physicscodes.objects.Particle;
	
	public class Ball extends Particle{
		
		private var _radius:Number;
		private var _color:uint;
		private var _particle:Particle;
		private var _gradient:Boolean;

		public function Ball(pradius:Number=20,pcolor:uint=0x0000ff,pmass:Number=1,pcharge:Number=0,pgradient:Boolean=true){
			this.mass=pmass;
			this.charge=pcharge;
			_radius=pradius;
			_color=pcolor;
			_gradient = pgradient;
			_particle = new Particle(pmass,pcharge);
			drawBall();
		}

		private function drawBall():void{
			var matrix:Matrix = new Matrix();
			matrix.createGradientBox(_radius,_radius,0,-_radius,-_radius/2);
			with (_particle.graphics){	
				if (_gradient){
					beginGradientFill(GradientType.RADIAL,[0xffffff,_color],[1,1],[0,255],matrix);
				}else{
					beginFill(_color);
				}
				drawCircle(0,0,_radius);
				endFill();
			}
			addChild(_particle);
		}		
		
		public function clone():Ball{
			return new Ball(_radius,_color);			
		}
		
		public function clear():void{
			_particle.graphics.clear();
			removeChild(_particle);
		}

		public function get radius():Number{
			return _radius;
		}
		
		public function set radius(pradius:Number):void{
			_radius = pradius;
			clear();
			drawBall();
		}
		
		public function get color():Number{
			return _color;
		}
		
		public function set color(pcolor:Number):void{
			_color = pcolor;
			clear();
			drawBall();
		}
	}
	
}
