package {
	import com.physicscodes.motion.MultiForcerRB;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.RigidBody;		
	import com.physicscodes.math.Vector2D;
	import flash.events.MouseEvent;		
	
	public class TurbinesMover extends MultiForcerRB{
		private var _bodies:Array;		
		private var _k:Number=0.5; // współczynnik tłumienia prędkości kątowej
		private var _tqMax:Number=2;		
		private var _tq:Number=0;

		public function TurbinesMover(pbodies:Array):void{
			_bodies = pbodies;			
			_bodies[0].stage.addEventListener(MouseEvent.MOUSE_DOWN,onDown);						
			super(pbodies);
		}	
		
		// NB: należy podać zarówno siłę, jak i moment siły
		override protected function calcForce(pbody:RigidBody,pnum:uint):void{
			force = Forces.zeroForce();
			torque = _tq;
			torque += -_k*pbody.angVelo; // tłumienie w ruchu obrotowym
		}
		
		private function onDown(e:MouseEvent):void{
			_bodies[0].stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
			_tq = _tqMax;
		}
		private function onUp(e:MouseEvent):void{
			_bodies[0].stage.removeEventListener(MouseEvent.MOUSE_UP,onUp);
			_tq = 0;
		}						
	}
}
