﻿package com.physicscodes.objects {
	import flash.display.Sprite;
	import com.physicscodes.math.Vector2D;
	
	public class Wall extends Sprite{
		
		private var _p1:Vector2D;
		private var _p2:Vector2D;
		private var _sprite:Sprite;			
		
		public function Wall(p1:Vector2D,p2:Vector2D){
			_p1 = p1;
			_p2 = p2;
			_sprite = new Sprite();
			drawWall();
		}
		
		public function get p1():Vector2D{
			return _p1;
		}
		public function set p1(pvec:Vector2D):void{
			_p1 = pvec;	
			clear();
			drawWall();
		}
		public function get p2():Vector2D{
			return _p2;
		}
		public function set p2(pvec:Vector2D):void{
			_p2 = pvec;	
			clear();
			drawWall();			
		}		
		
		public function get dir():Vector2D{
			return _p2.subtract(_p1);
		}
		
		public function get normal():Vector2D{
			return this.dir.perp(1);
		}		

		private function drawWall():void{
			with (_sprite.graphics){	
				lineStyle(1);
				moveTo(_p1.x,_p1.y);
				lineTo(_p2.x,_p2.y);
			}
			addChild(_sprite);
		}	
		
		public function clear():void{
			_sprite.graphics.clear();
			removeChild(_sprite);
		}		
			
	}
}