package{
	import flash.display.Sprite;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;
	
	public class Cloth extends Sprite{
		public function Cloth():void{
			init();
		}

		private function init():void{
			// tworzy obiekt Sprite, w którym rysowana będzie sprężyna
			var spring:Sprite=new Sprite();
			addChild(spring);
			
			// towrzy masy
			var rows:uint=10;			
			var cols:uint=15;
			var refPoint:Vector2D = new Vector2D(120,50);
			var objects:Array = new Array();			
			for (var i:uint=0; i<cols*rows; i++){							
				var object:Ball= new Ball(2,0x000000,10);
				var ncol:Number=Math.floor(i/rows);
				var spacing:Number = 20; // wartość bliska długości sprężyny
				object.pos2D = new Vector2D(refPoint.x+ncol*spacing,refPoint.y+(i-ncol*rows-1)*spacing);	
				addChild(object);
				objects.push(object);
			}
			
			// punkty ustalone
			var fixedPoints:Array = new Array(0,70,140);
			
			// wprawia układ w ruch
			var mover:ClothMover=new ClothMover(objects,fixedPoints,cols,rows,spring);
			mover.startTime();
		}
	}
}