package {
	import com.physicscodes.motion.Forcer;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.Ball;		
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.math.Graph;		

	public class GravityAttractor extends Forcer{
		
		private var _orbiter:Ball;			
		private var _attractors:Array;
		private var _massOrbiter:Number;
		private var _G:Number;
		private var _graph:Graph;		
		private var _stageWidth;
		private var _stageHeight;

		public function GravityAttractor(porbiter:Ball,pattractors:Array,pG:Number):void{
			_orbiter = porbiter;
			_attractors = pattractors;
			_massOrbiter = porbiter.mass;			
			_G = pG;
			_stageWidth = _orbiter.stage.stageWidth;			
			_stageHeight = _orbiter.stage.stageHeight;		
			setupGraph();
			super(porbiter);
		}	
		
		override protected function calcForce():void{
			var gravity:Vector2D = Forces.zeroForce();
			force = Forces.zeroForce();
			for (var i:uint=0; i<_attractors.length; i++){
				var attractor:Ball=_attractors[i];
				var dist:Vector2D = _orbiter.pos2D.subtract(attractor.pos2D);
				if (dist.lengthSquared > Math.pow(attractor.radius+_orbiter.radius,2)){
					gravity = Forces.gravity(_G,attractor.mass,_massOrbiter,dist);		
					force = Forces.add([force, gravity]);					
				}else{
					//gravity = Forces.spring(_G*attractor.mass*_massOrbiter/Math.pow(attractor.radius,3),dist);
					recycleOrbiter();
				}
			}
		}
		
		override protected function moveObject():void{
			super.moveObject();
			plotGraph();		
			if (_orbiter.xpos < 0 || _orbiter.xpos > _stageWidth || _orbiter.ypos < 0 || _orbiter.ypos > _stageHeight){
				recycleOrbiter();
			}
		}
		
		private function recycleOrbiter():void{
			_orbiter.color = Math.random()*0xffffff;
			_orbiter.pos2D = new Vector2D(Math.random()*_stageWidth,Math.random()*_stageHeight);
			_orbiter.velo2D = new Vector2D((Math.random()-0.5)*100,(Math.random()-0.5)*100);
		}

		private function setupGraph():void {
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graph= new Graph(0,_stageWidth,0,_stageHeight,0,0,_stageWidth,_stageHeight);						
			_orbiter.stage.addChild(_graph);
		}
		private function plotGraph():void{
			_graph.plot([_orbiter.xpos], [-_orbiter.ypos], _orbiter.color, false, true);		
		}	
		
	}
}
