package{
	import flash.display.Sprite;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.math.Vector2D;	
	import com.physicscodes.objects.Particle;
	import flash.display.Graphics;

	public class BlackHoles extends Sprite{
		public function BlackHoles():void{
			init();
		}
		private function init():void{
			var timeStep:Number = 10; // krok czasowy symulacji w milisekundach			
			var G:Number = 1; // Stała grawitacji			
			var c:Number = 200; // prędkość światła		
			var numCenters = 1; 

			// tworzy linie startu i mety
			var yposWinning:Number=50;
			var yposEdge:Number=400;
			with (graphics){
				lineStyle(2,0xccffcc);
				moveTo(0,yposWinning);
				lineTo(stage.stageWidth,yposWinning);
				lineStyle(1,0xccccff);
				moveTo(0,yposEdge);
				lineTo(stage.stageWidth,yposEdge);
			}

			// tworzy statek kosmiczny
			var ship:Spaceship = new Spaceship(10,15,0xff0000,1);
			ship.pos2D = new Vector2D(stage.stageWidth/2,stage.stageHeight-50);
			addChild(ship);		

			// tworzy czarne dziury
			var centers:Array = new Array();
			for (var i:uint=0; i<numCenters; i++){
				var radius:Number=20*(Math.random()+0.5);
				var mass:Number=(0.5*c*c/G)*radius; // wzór pozwalający wyznaczyć masę czarnej dziury
				var center:Ball = new Ball(radius,0x000000,mass,0,false);	
				center.pos2D = new Vector2D(Math.random()*stage.stageWidth,Math.random()*(yposEdge-yposWinning)+yposWinning);
				addChild(center);		
				centers[i] = center;
			}

			// wprawia statek w ruch
			var attractor:BlackHoleAttractor=new BlackHoleAttractor(ship,centers,G,c,yposWinning,yposEdge);		
			attractor.startTime(timeStep);
		}
	}
}