package {
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.motion.MultiForcer2;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.objects.Particle;
	
	import flash.display.Sprite;
	
	public class CoupledOscillator extends MultiForcer2{
		private var _objects:Array;
		private var _support:Ball;
		private var _center:Vector2D;
		private var _displ:Vector2D;
		private var _g:Number=20;
		private var _kDamping:Number=0.5;
		private var _kSpring:Number=10;
		private var _springLength:Number=50;
		private var _spring:Sprite;

		public function CoupledOscillator(pobjects:Array,psupport:Ball,pspring:Sprite):void{
			_objects = pobjects;
			_support = psupport;
            _center = _support.pos2D;
			_spring = pspring;
			super(_objects);
		}
		
		override protected function moveObject():void{
			super.moveObject();
			drawSpring();			
			_support.xpos = 100*Math.sin(1.0*time)+275;	
			_center = _support.pos2D;
		}		

		override protected function calcForce(pparticle:Particle,pnum:uint):void{
			var centerPrev:Vector2D;
			var centerNext:Vector2D;
			if (pnum > 0){
				centerPrev = _objects[pnum-1].pos2D;
			}else{
				centerPrev = _center;
			}
			if (pnum < _objects.length-1){
				centerNext = _objects[pnum+1].pos2D;
			}else{
				centerNext = pparticle.pos2D;
			}
			var gravity:Vector2D = Forces.constantGravity(pparticle.mass,_g);
			var damping:Vector2D = Forces.damping(_kDamping,pparticle.velo2D);				
			var displPrev:Vector2D = pparticle.pos2D.subtract(centerPrev);
			var displNext:Vector2D = pparticle.pos2D.subtract(centerNext);			
			var extensionPrev:Vector2D = displPrev.subtract(displPrev.unit().multiply(_springLength));
			var extensionNext:Vector2D = displNext.subtract(displNext.unit().multiply(_springLength));	
			var restoringPrev:Vector2D = Forces.spring(_kSpring,extensionPrev);
			var restoringNext:Vector2D = Forces.spring(_kSpring,extensionNext);									
			force = Forces.add([gravity, damping, restoringPrev, restoringNext]);
		}			
		
		private function drawSpring():void{
			with (_spring.graphics){
				clear();		
				lineStyle(2,0x999999);
				moveTo(_center.x,_center.y);
				for (var i:uint=0; i<_objects.length; i++){ 
					var X:Number = _objects[i].xpos;
					var Y:Number = _objects[i].ypos;
					lineTo(X,Y);
				}
			}
		}
				
	}
}