﻿package{
	
	import com.physicscodes.motion.Mover;
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;


	public class Projectile extends Mover{
		
		private var _particle:Particle;
		private var _acc:Vector2D;
		private var _pos0:Vector2D;
		private var _velo0:Vector2D;		
		private var _euler:Boolean;

		public function Projectile(pparticle:Particle, ppos0:Vector2D, pvelo0:Vector2D, pacc:Vector2D, peuler:Boolean=true):void{
			_particle = pparticle;
			_acc = pacc;
			_euler = peuler;
			_pos0 = ppos0;
			_velo0 = pvelo0;
			super(pparticle);
		}	
		
		override protected function moveObject():void{
			if (_euler){
				super.moveObject();
				updateVelo();
			}else{
				useAnalyticalSoln();
			}
		}
		
		private function updateVelo():void{
			//_particle.velo2D = _particle.velo2D.add(_acc.multiply(dt));	
			_particle.velo2D = _particle.velo2D.addScaled(_acc,dt);				
		}
		
		private function useAnalyticalSoln():void{
			//_particle.pos2D = (_velo0.multiply(time)).add(_acc.multiply(0.5*time*time)).add(_pos0) ;
			_particle.pos2D = _pos0.addScaled(_velo0,time).addScaled(_acc,0.5*time*time);
		}
	
	}
	
}