﻿package {
	
	import com.physicscodes.motion.Mover;
	import com.physicscodes.objects.Particle;		
	import com.physicscodes.math.Vector2D;
	import com.physicscodes.math.Graph;

	public class Faller extends Mover{
		
		private var _particle:Particle;
		private var _force:Vector2D;
		private var _acc:Vector2D;	
		private var _g:Number=10;
		private var _k:Number=0.5;
		private var _graphAcc:Graph;
		private var _graphVelo:Graph;		

		public function Faller(pparticle:Particle):void{
			_particle = pparticle;
			setupGraphs();
			super(pparticle);
		}	
		
		override protected function moveObject():void{
			super.moveObject();
			calcForce();
			updateAccel();
			updateVelo();
			plotGraphs();
		}
		
		private function calcForce():void{
			_force = new Vector2D(0,_particle.mass*_g-_k*_particle.vy);
		}
		
		private function updateAccel():void{
			_acc = _force.multiply(1/_particle.mass);
		}
		
		private function updateVelo():void{
			_particle.velo2D = _particle.velo2D.addScaled(_acc,dt);				
		}
		
		private function setupGraphs():void{
			//_graph= new Graph(xmin,xmax,ymin,ymax,xorig,yorig,xwidth,ywidth);	
			_graphAcc= new Graph(0,30,0,10,150,250,600,200);					
			_graphAcc.drawgrid(5,1,5,1);			
			_graphAcc.drawaxes('time (s)','acceleration (px/s/s)');		
			_particle.stage.addChild(_graphAcc);
			_graphVelo= new Graph(0,30,0,25,150,550,600,200);					
			_graphVelo.drawgrid(5,1,5,1);			
			_graphVelo.drawaxes('time (s)','velocity (px/s)');		
			_particle.stage.addChild(_graphVelo);			
		}
		
		private function plotGraphs():void{
			_graphAcc.plot([time], [_acc.y], 0xff0000, false, true);			
			_graphVelo.plot([time], [_particle.vy], 0xff0000, false, true);						
		}
	
	}
	
}