package com.physicscodes.motion{
	import com.physicscodes.math.Vector3DX;

	public class Forces3DX {

		public function Forces3DX():void {
		}
		static public function zeroForce():Vector3DX {
			return (new Vector3DX(0,0,0));
		}
		static public function constantGravity(m:Number,g:Number):Vector3DX {
			return new Vector3DX(0,m*g,0);
		}
		static public function gravity(G:Number,m1:Number,m2:Number,r:Vector3DX):Vector3DX {
			var vec:Vector3DX = r;
			vec.scaleBy(-G*m1*m2/(r.lengthSquared*r.length));
			return vec;
		}	
		static public function electric(k:Number,q1:Number,q2:Number,r:Vector3DX):Vector3DX {
			var vec:Vector3DX = r;
			vec.scaleBy(k*q1*q2/(r.lengthSquared*r.length));
			return vec;
		}		
		static public function forceField(q:Number,E:Vector3DX):Vector3DX {
			var vec:Vector3DX = E;
			vec.scaleBy(q);
			return vec;
		}	
		static public function central(k:Number,n:Number,r:Vector3DX):Vector3DX {
			var vec:Vector3DX = r;
			vec.scaleBy(k*Math.pow(r.length,n-1));
			return vec;			
		}		
		static public function linearDrag(k:Number,vel:Vector3DX):Vector3DX {
			var force:Vector3DX;
			var vec:Vector3DX = vel;
			var velMag:Number=vel.length;
			vec.scaleBy(-k);						
			if (velMag>0) {
				force=vec;
			}
			else {
				force=new Vector3DX(0,0,0);
			}
			return force;
		}
		static public function drag(k:Number,vel:Vector3DX):Vector3DX {
			var force:Vector3DX;
			var vec:Vector3DX = vel;				
			var velMag:Number=vel.length;
			vec.scaleBy(-k*velMag);					
			if (velMag>0) {
				force=vec;
			}
			else {
				force=new Vector3DX(0,0,0);
			}
			return force;			
		}
		static public function lift(k:Number,vel:Vector3DX):Vector3DX {
			var force:Vector3DX;
			var velMag:Number=vel.length;
			if (velMag>0) {
				// niezbędne, by siła nośna została zapisana jako wektor
	//			force=vel.perp(k*velMag);
			}
			else {
				force=new Vector3DX(0,0,0);
			}
			return force;			
		}			
		static public function upthrust(rho:Number,V:Number,g:Number):Vector3DX {
			return new Vector3DX(0,-rho*V*g,0);
		}	

		static public function spring(k:Number,r:Vector3DX):Vector3DX {
			var vec:Vector3DX = r;
			vec.scaleBy(-k);	
			return vec;
		}		
		static public function damping(c:Number,vel:Vector3DX):Vector3DX {
			var force:Vector3DX;
			var vec:Vector3DX = vel;
			var velMag:Number=vel.length;
			vec.scaleBy(-c);
			if (velMag>0) {
				force=vec;
			}
			else {
				force=new Vector3DX(0,0,0);
			}
			return force;
		}				
		
		static public function add(arr:Array):Vector3DX {
			var forceSum:Vector3DX = new Vector3DX(0,0,0);
			for (var i:uint=0; i<arr.length; i++){
				var force:Vector3DX = arr[i];
				forceSum.incrementBy(force);
			}
			return forceSum;
		}

	}
}