﻿package com.physicscodes.objects{
	import flash.display.Sprite;
	import flash.geom.Vector3D;		
	import flash.geom.Matrix3D;
	import flash.geom.Point;	

	public class Plane extends RigidBody3D{
		private var _vertices:Vector.<Vector3D>;
		private var _numVertices:int;
		private var _cm:Vector3D;	
		private var _sprite:Sprite;		
		private var _container:Sprite;
		private var _fl:Number=300;
		
		private var _ix:Vector3D=new Vector3D();
		private var _iy:Vector3D=new Vector3D();
		private var _iz:Vector3D=new Vector3D();		

		public function Plane(pcm:Vector3D, pim:Vector3D, pvertices:Vector.<Vector3D>, pmass:Number=1, pcharge:Number=0){
			_cm = pcm;
			_vertices = pvertices;
			_numVertices = pvertices.length;
			_sprite = new Sprite();
			_sprite.z = 0;
			_container = new Sprite();
			addChild(_container);
			this.centerOfMass = pcm;
			this.Im = pim;
			this.mass = pmass;
			this.charge = pcharge;
			super(pcm,pim,pmass,pcharge);
			updatePlane(0,0,-90);
		}

		public function get vertices():Vector.<Vector3D>{
			return _vertices;
		}
		public function set vertices(pvertices:Vector.<Vector3D>):void{
			vertices = _vertices;
			drawPlane();
		}
		
		public function get ix():Vector3D{
			return _ix;
		}
		
		public function get iy():Vector3D{
			return _iy;
		}
		
		public function get iz():Vector3D{
			return _iz;
		}
		
		public function clear():void{
			_container.graphics.clear();
		}

		public function updatePlane(rotx:Number,roty:Number,rotz:Number):void{			
			// add incremental rotations to matrix3D property of _sprite
			_sprite.transform.matrix3D.appendRotation(rotx,Vector3D.X_AXIS);
			_sprite.transform.matrix3D.appendRotation(roty,Vector3D.Y_AXIS);
			_sprite.transform.matrix3D.appendRotation(rotz,Vector3D.Z_AXIS);						

			var clMat:Matrix3D = _sprite.transform.matrix3D.clone();
			// unit vectors of the coordinate systems linked with the object 
			_ix= clMat.deltaTransformVector(Vector3D.X_AXIS);
		    _iy= clMat.deltaTransformVector(Vector3D.Y_AXIS);
			_iz= clMat.deltaTransformVector(Vector3D.Z_AXIS);			

			drawPlane();					
		}

		// apply matrix3d transform and draw polyhedron in 3D using perspective projection and depth sorting
		private function drawPlane():void{
			var i:uint;
			var newVertices:Vector.<Vector3D>=new Vector.<Vector3D>();
			var projVertices:Vector.<Point>=new Vector.<Point>();						

			//	transform vertices based on current matrix3D		
			for (i=0; i<_numVertices; i++){
				newVertices[i] = _sprite.transform.matrix3D.deltaTransformVector(_vertices[i]);
			}
			// apply perspective distortion
			for (i=0; i<_numVertices; i++){
				newVertices[i].w = (_fl + newVertices[i].z) / _fl;
				newVertices[i].project();
			}
			// 2D points for drawing
			for (i=0; i<_numVertices; i++){
				projVertices[i] = new Point();
				projVertices[i].x = newVertices[i].x;
				projVertices[i].y = newVertices[i].y;
			}			
			
			// draw object
			clear();
			with (_container.graphics){
				beginFill(0x000000);
				moveTo(projVertices[0].x,projVertices[0].y);
				for (i=1; i<_numVertices; i++){
					lineTo(projVertices[i].x,projVertices[i].y);
				}
				lineTo(projVertices[0].x,projVertices[0].y);
				endFill();
			}

		}		

	}
}