package {
	import com.physicscodes.motion.MultiForcer2;
	import com.physicscodes.motion.Forces;
	import com.physicscodes.objects.Ball;
	import com.physicscodes.objects.Particle;	
	import com.physicscodes.math.Vector2D;
	import flash.display.Sprite;
	import flash.events.MouseEvent;		
	
	public class RopeMover2 extends MultiForcer2{
		private var _objects:Array;
		private var _support:Ball;
		private var _center:Vector2D;
		private var _displ:Vector2D;
		private var _g:Number=10;
		private var _kDamping:Number=20;
		private var _kSpring:Number=500;
		private var _springLength:Number=20;
		private var _spring:Sprite;
		private var _pull:Boolean=false;
		private var _pfac:Number=50; // współczynnik określający wartość naciągu przy naciśniętym przycisku myszy

		public function RopeMover2(pobjects:Array,psupport:Ball,pspring:Sprite):void{
			_objects = pobjects;
			_support = psupport;
            _center = _support.pos2D;
			_spring = pspring;
			_spring.stage.addEventListener(MouseEvent.MOUSE_DOWN,onDown);										
			super(_objects);
		}
		
		override protected function moveObject():void{
			super.moveObject();
			drawSpring();				
			_center = _support.pos2D;
		}		

		override protected function calcForce(pparticle:Particle,pnum:uint):void{
			var centerPrev:Vector2D;
			var centerNext:Vector2D;
			var veloPrev:Vector2D;
			var veloNext:Vector2D;			
			if (pnum > 0){
				centerPrev = _objects[pnum-1].pos2D;
				veloPrev = _objects[pnum-1].velo2D;
			}else{
				centerPrev = _center;
				veloPrev = new Vector2D(0,0);
			}
			if (pnum < _objects.length-1){
				centerNext = _objects[pnum+1].pos2D;
				veloNext = _objects[pnum+1].velo2D;
			}else{
				centerNext = pparticle.pos2D;
				veloNext = pparticle.velo2D;
			}
			var gravity:Vector2D = Forces.constantGravity(pparticle.mass,_g);
		//	var damping:Vector2D = Forces.damping(_kDamping,pparticle.velo2D);				
			var velo:Vector2D = pparticle.velo2D.multiply(2).subtract(veloPrev).subtract(veloNext);
			var damping:Vector2D = Forces.damping(_kDamping,velo);							
			//var dampingPrev:Vector2D = Forces.damping(_kDamping,pparticle.velo2D.subtract(veloPrev));				
			//var dampingNext:Vector2D = Forces.damping(_kDamping,pparticle.velo2D.subtract(veloNext));					
			var displPrev:Vector2D = pparticle.pos2D.subtract(centerPrev);
			var displNext:Vector2D = pparticle.pos2D.subtract(centerNext);			
			var extensionPrev:Vector2D = displPrev.subtract(displPrev.unit().multiply(_springLength));
			var extensionNext:Vector2D = displNext.subtract(displNext.unit().multiply(_springLength));	
			var restoringPrev:Vector2D = Forces.spring(_kSpring,extensionPrev);
			var restoringNext:Vector2D = Forces.spring(_kSpring,extensionNext);									
			force = Forces.add([gravity, damping, restoringPrev, restoringNext]);	
//			force = Forces.add([gravity, dampingPrev, dampingNext, restoringPrev, restoringNext]);	
			if (pnum==_objects.length-1){ // last particle
				if (_pull){ // gdy naciśnięty jest przycisk myszy
					var fx:Number = _spring.stage.mouseX-pparticle.xpos; // odledłość wzdłuż osi x od kursora do ostatniej cząstki
					var fy:Number = _spring.stage.mouseY-pparticle.ypos; // odledłość wzdłuż osi y od kursora do ostatniej cząstki
					var pull:Vector2D = new Vector2D(_pfac*fx,_pfac*fy); // siła naciągu w kierunku kursora proporcjonalna do odległości od cząstki
					force = Forces.add([damping, restoringPrev, restoringNext, pull]);
				}else{ // if mouse is not pressed hold last particle fixed
					force = new Vector2D(0,0);
					pparticle.velo2D = new Vector2D(0,0);
				}
			}
		}			
		
		private function drawSpring():void{
			with (_spring.graphics){
				clear();		
				lineStyle(2,0x009999);
				moveTo(_center.x,_center.y);
				for (var i:uint=0; i<_objects.length; i++){ 
					var X:Number = _objects[i].xpos;
					var Y:Number = _objects[i].ypos;
					lineTo(X,Y);
				}
			}
		}
		
		private function onDown(e:MouseEvent):void{
			_spring.stage.addEventListener(MouseEvent.MOUSE_UP,onUp);
			_pull = true;
		}
		private function onUp(e:MouseEvent):void{
			_spring.stage.removeEventListener(MouseEvent.MOUSE_UP,onUp);
			_pull = false;
		}		
				
	}
}