package {
	import com.physicscodes.motion.ForcerRB;
	import com.physicscodes.motion.Forces;	
	import com.physicscodes.objects.RigidBody;
	import com.physicscodes.objects.BallRB;	
	import com.physicscodes.math.Vector2D;

	public class RollingMover extends ForcerRB{
		private var _body:BallRB;		
		private var _angle:Number;			
		private var _g:Number=10;
		private var _ck:Number=0.2;
		private var _cs:Number=0.25;	
		private var _vtol:Number=0.000001;

		public function RollingMover(pbody:BallRB,pangle:Number):void{		
			_body = pbody;					
			_angle = pangle;
			super(pbody);
		}	
	
		override protected function calcForce():void{
			var gravity:Vector2D = Forces.constantGravity(_body.mass,_g);
			var normal:Vector2D = Vector2D.vector2D(_body.mass*_g*Math.cos(_angle),0.5*Math.PI-_angle,false);
			var coeff:Number;
			/*
			if (_body.velo2D.length < _vtol){  // tarcie statyczne
				coeff = Math.min(_cs*normal.length,_body.mass*_g*Math.sin(_angle)); 
			}else{  // tarcie kinetyczne
				coeff = _ck*normal.length; 
			}
			*/
			coeff = _body.mass*_g*Math.sin(_angle)/(1+_body.mass*_body.radius*_body.radius/_body.momentOfInertia);
			if (coeff > _cs*normal.length){
				coeff = _ck*normal.length; 
				trace("slipping");
			}
			var friction:Vector2D = normal.perp(coeff);						
			force = Forces.add([gravity, normal, friction]);		
			torque = _body.radius*friction.length;
			/*
			if (_body.y > 250-_body.radius){
				trace(time);
				stopTime();
			}
			*/
		}
	}
}
