/* ========================================
Sterownik MAX7219 - Matryca LED
(c)2021 Filip Sala, Marzena Sala-Tefelska
===========================================*/
#include <avr/io.h>
#include <util/delay.h>
#include "spi_lib.h"
//liczba segmentów (modułów) lub linii
#define NUMBER_OF_SEGMENTS 8
//jasność od 0 do 15
#define BRIGHTNESS 5
uint8_t line[8] = {0x01, 0x03, 0x07, 0x0F, 0x1F, 0x3F, 0x7F, 0xFF};
void MAX7219_send(uint8_t addr, uint8_t data)
{
 CLR_CS;
 SPI_send(addr);
 SPI_send(data);
 SET_CS; 
}

void MAX7219_clear(void)
{
 for (uint8_t i = 0; i < NUMBER_OF_SEGMENTS; i++)
  MAX7219_send(i+1,0x00);
}

void MAX7219_single_pixel(uint8_t x, uint8_t y)
{
 MAX7219_clear();
 MAX7219_send(x+1,(1 << y));
}

void MAX7219_line(uint8_t x, uint8_t length)
{
 MAX7219_send(x+1, line[length-1]);
}

int main (void)
{
 SPI_init();
 MAX7219_send(0x0A,BRIGHTNESS); // jasność 5
 MAX7219_send(0x0B,(NUMBER_OF_SEGMENTS -1)); // liczba wyświetlaczy lub linii
 MAX7219_send(0x0C,0x01); // włączenie wyświetlacza
 MAX7219_send(0x0F,0x00); // tryb normalny (test  mode: off)
 MAX7219_send(0x09,0x00); // tryb dekodowania, 0x00 - brak, 0xFF - BCD
 while (1)
 {
  for (uint8_t x = 0; x <=7 ; x++)
   for (uint8_t y = 0; y <=7 ; y++)
   {
    MAX7219_single_pixel(x,y);
    _delay_ms(50);  
   }    
  for (uint8_t x = 0; x <=7 ; x++)
  {
   MAX7219_send(x+1,0xAA);
   _delay_ms(50);  
  }
  for (uint8_t x = 0; x <=7 ; x++)
  {
   MAX7219_send(x+1,0x55);
   _delay_ms(50);  
  }
  for (uint8_t x = 0; x <=7 ; x++)
  {
   MAX7219_line(x,x+1);
   _delay_ms(100);  
  }
 }
 return 0;
}