/* ========================================
Sterowanie brzęczykiem
(c)2021 Filip Sala, Marzena Sala-Tefelska
===========================================*/
#include <avr/io.h>
#include <util/delay.h>
#define MY_PORT PORTD
#define MY_DDR DDRD
#define MY_PIN PD0

void short_beep(void)
{
 MY_PORT |= (1 << MY_PIN);
 _delay_ms(100);
 MY_PORT &=~(1 << MY_PIN); 
 _delay_ms(100);
}

void long_beep(void)
{
 MY_PORT |= (1 << MY_PIN);
 _delay_ms(300);
 MY_PORT &=~(1 << MY_PIN); 
 _delay_ms(100);
}

int main (void)
{
 MY_DDR |= (1 << PD0); //ustawienie kierunku wyjściowego
 while (1)
 {
  short_beep();
  short_beep();
  long_beep();
  short_beep();
  _delay_ms(200);
  long_beep();
  long_beep();
  _delay_ms(600);
 }
  return 0;
}