/* ========================================
Czujnik alkoholu MQ-3 v.2 
(c)2021 Filip Sala, Marzena Sala-Tefelska
===========================================*/
/* Pojedyncza konwersja, pomiar napięcia na ADC0, 
Program dla ATmega8/16/32 oraz ATmega48/88/168/328 */
#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>
#include "lcd_lib.h"
#include <math.h>
//R0 - rezystancja czujnika przy stężeniu 0.4mg/L (400ug/L)
#define R0 1000
//RL - rezystancja rezystora, na ktorym mierzymy napięcie
#define RL 15000
//Vcc - napięcie zasilania w mV
#define Vcc 5000
//A i B - współczynniki charakterystyki czujnika
#define A_COEFF 0.3812
#define B_COEFF -1.4605
volatile uint16_t adc_value, voltage, concentration;

ISR (ADC_vect)
{
 uint32_t Lbyte, Hbyte;
 Lbyte = ADCL;
 Hbyte = (ADCH & 0x03);
 adc_value = (Lbyte + (Hbyte << 8));
 voltage = ((uint32_t) adc_value * Vcc) / 1023;
 //stężenie w mikrogramach na litr
 concentration =  (uint16_t) (1000 * A_COEFF * pow(10 , (B_COEFF * log10((((1023 * (float) RL) / adc_value) - RL) / R0))));
}

int main (void)
{
 lcd_init();
 lcd_display_control(1,0,0);
 sei();
 // Inicjalizacja przetwornika analogowo-cyfrowego (ADC) 
 // w trybie free running, preskaler 128 + przerwania
 ADMUX |= (1 << REFS0);  //(Vref = Vcc)
 // włączenie przerwań, właczenie ADC
 ADCSRA |=  (1 << ADIE) | (1 << ADEN);  
 //preskaler 128	
 ADCSRA |=  (1 << ADPS0) | (1 << ADPS1) | (1 << ADPS2); 
  while (1)
 {
  ADCSRA |=  (1 << ADSC); //start konwersji
  lcd_gotoXY(0,0);
  lcd_text("V=");
  lcd_integer (voltage); 
  lcd_text("mV     ");
  lcd_gotoXY(0,1);
  lcd_text("S=");
  lcd_integer (concentration); 
  lcd_text("ug/L");
  lcd_text("      ");
  _delay_ms(500);
 }
 return 0;
}