#include "ow_lib.h"

uint8_t OW_reset(void)
{
 OW_LOW;          // ustawiamy stan niski
 _delay_us(480);  //czekamy 480us
 OW_HIGH; // stan High-Z
 _delay_us(70); // czekamy 70us
 uint8_t state = OW_STATE; 
 _delay_us(410); // czekamy 410us
 return state;
}

static void OW_write_bit(uint8_t bit)
{
 OW_LOW;          // ustawiamy stan niski
 if (bit) 
 {
  _delay_us(6); 
  OW_HIGH;
  _delay_us(64);
 }
 if (!bit)
 {
  _delay_us(60);
  OW_HIGH;
  _delay_us(10);
 }
}

uint8_t OW_read_bit(void)
{
 OW_LOW;
 _delay_us(6);
 OW_HIGH;
 _delay_us(9);
 uint8_t bit;
 if (OW_STATE) bit = 1; else bit = 0;
 _delay_us(55); 
 return bit;
}

void OW_write_byte(uint8_t data)
{
 for (int8_t i = 0;i <= 7;i++) OW_write_bit(data & (1 << i));
// lub alternatywnie 
//for (int8_t i = 0;i <= 7;i++) OW_write_bit(!!(data & (1 << i)));
//for (int8_t i=0;i<=7;i++) OW_write_bit((data & (1 << i))>> i);
//for (int8_t i=0;i<=7;i++) OW_write_bit((data >> i) & 0x01); 
}

uint8_t OW_read_byte(void)
{
 uint8_t byte = 0;
 for (int8_t i = 0;i <= 7;i++) byte |= (OW_read_bit() << i);
 return byte;
}

void DS18B20_set_resolution (uint8_t resolution)
{
 if (!OW_reset())
 {
  OW_write_byte(0xCC);
  OW_write_byte(0x4E); //write scratchpad
  OW_write_byte(0x0F); // bajt TH
  OW_write_byte(0x00); // bajt TL
  if (resolution == 9) OW_write_byte(0x1F); else 
   if (resolution == 10) OW_write_byte(0x3F); else 
    if (resolution == 11) OW_write_byte(0x5F); else 
      OW_write_byte(0x7F); //12 bitów 
  OW_reset();
 }
}