/* ==============================================================
Obsługa klawiatury numerycznej
(c)2021 Filip Sala, Marzena Sala-Tefelska

Podłączenie: patrząc na klawiaturę pierwszy pin od lewej 
podłączamy do PD7, a pierwszy pin od prawej do PD0
Kolumny liczymy od prawej do lewej, a rzędy od dołu w górę
================================================================*/
#include <avr/io.h>
#include <util/delay.h>
#include "lcd_lib.h"

int main (void)
{
 lcd_init();
 uint8_t pressed_column, pressed_row;
 uint16_t pressed_button;
 while (1) 
 {  
  pressed_column = 0;
  pressed_row = 0;
  DDRD = 0x0F; 
  PORTD = 0xF0;
  _delay_ms(5);
  for (uint8_t row = 0; row <= 3 ; row++)
   if (!(PIND & (1 << (4+row)))) pressed_row = row + 1;
  DDRD = 0xF0;
  PORTD = 0x0F;
  _delay_ms(5);
  for (uint8_t column = 0; column <= 3 ; column++)
   if (!(PIND & (1 << (column)))) pressed_column = column + 1;
  pressed_button = (1 << pressed_row) + (1 << (4 + pressed_column));
  lcd_clear();
  lcd_integer(pressed_button);
  lcd_text(" : ");
  if (pressed_button == 17) lcd_text("brak"); //(1 << 0) + (1 << 4) 
  if (pressed_button == 272) lcd_text("1");  //(1 << 4) + (1 << (4+4)) rzad 4, kolumna 4
  if (pressed_button == 144) lcd_text("2"); // (1 << 4) + (1 << (4+3)) rząd 4, kolumna 3
  if (pressed_button == 80) lcd_text("3");  
  if (pressed_button == 264) lcd_text("4");
  if (pressed_button == 136) lcd_text("5");
  if (pressed_button == 72) lcd_text("6");
  if (pressed_button == 260) lcd_text("7");
  if (pressed_button == 132) lcd_text("8"); // (1 << 2) + (1 << (4+3)) rząd 2, kolumna 3
  if (pressed_button == 68) lcd_text("9");
  if (pressed_button == 130) lcd_text("0");
  if (pressed_button == 48) lcd_text("A");
  if (pressed_button == 40) lcd_text("B");
  if (pressed_button == 36) lcd_text("C");
  if (pressed_button == 34) lcd_text("D");
  if (pressed_button == 66) lcd_text("#");
  if (pressed_button == 258) lcd_text("*");
  _delay_ms(200);
 }
 return 0; 
} 

