/* ========================================
Sterowanie silnikiem krokowym
(c)2021 Filip Sala, Marzena Sala-Tefelska
===========================================*/
/* ---------------------------------------------
Silnik podłączamy do portu MOTOR_PORT
poprzez odpowiedni stopień mocy np. ULN2003
Przewody podłączamy po kolei do pinów od 0 do 3
na porcie MOTOR_PORT
------------------------------------------------ */
#include <avr/io.h>
#include <util/delay.h>
#define MOTOR_PORT PORTD
#define MOTOR_DDR DDRD
//MOTOR_DELAY - czas trwania jednego kroku
//Dla silnika 28BYJ-48 opóźnienie powinno wynosić powyżej 2-3ms (najlepiej >=10ms)
#define MOTOR_DELAY 20
//MODE - tryb 0 - jednofazowy, 1 - dwufazowy
#define MODE 0

int main (void)
{
 MOTOR_DDR |= 0x0F;
 while (1) 
 { 
  if (!MODE) //jednofazowy
  { 
    MOTOR_PORT = 1 << 0; //0001
    _delay_ms(MOTOR_DELAY);
    MOTOR_PORT = 1 << 1; //0010
    _delay_ms(MOTOR_DELAY);
    MOTOR_PORT = 1 << 2; //0100
    _delay_ms(MOTOR_DELAY);
    MOTOR_PORT = 1 << 3; //1000
    _delay_ms(MOTOR_DELAY);
  }
  if (MODE) //dwufazowy
  {
    MOTOR_PORT = 3 << 0; //0011
    _delay_ms(MOTOR_DELAY);
    MOTOR_PORT = 3 << 1; //0110
    _delay_ms(MOTOR_DELAY);
    MOTOR_PORT = 3 << 2; //1100
    _delay_ms(MOTOR_DELAY);
    MOTOR_PORT = (1 << 3) | (1 << 0); //1001
    _delay_ms(MOTOR_DELAY);
  }
 }
 return 0;
}
