/* ========================================
Biblioteka lcd_lib v. 7.0
(c)2021 Filip Sala, Marzena Sala-Tefelska
===========================================
W MAKEFILE powinny być wybrane następujące opcje aby korzystać z typów zmiennoprzecinkowych
w funkcji printf().
=========
MAKEFILE
=========
PRINTF_LIB_FLOAT = -Wl,-u,vfprintf -lprintf_flt
PRINTF_LIB = $(PRINTF_LIB_FLOAT)
MATH_LIB = -lm
 ==============================
*/
#include "lcd_lib.h"
//poniższą linię (definicję) należy odkomentować jeżeli chcemy korzystać z funkcji printf
#define USE_PRINTF

#ifdef USE_PRINTF
 static int lcd_char(char c, FILE *stream);
 FILE lcd_stream = FDEV_SETUP_STREAM(lcd_char, NULL, _FDEV_SETUP_WRITE);
#endif //USEPRINTF

static inline void lcd_send_4bits(uint8_t data) // wysyłanie 4 bitów
{
 SET_E;
 if (data & (1 << 0)) LCD_PORT |= (1 << LCD_D4); else LCD_PORT &= ~(1 << LCD_D4);
 if (data & (1 << 1)) LCD_PORT |= (1 << LCD_D5); else LCD_PORT &= ~(1 << LCD_D5);
 if (data & (1 << 2)) LCD_PORT |= (1 << LCD_D6); else LCD_PORT &= ~(1 << LCD_D6);
 if (data & (1 << 3)) LCD_PORT |= (1 << LCD_D7); else LCD_PORT &= ~(1 << LCD_D7);
 CLR_E;
}

// wysyłanie 8 bitów (cały bajt)
static inline void lcd_send_8bits(uint8_t data) 
{
 lcd_send_4bits(data >> 4); // wysyłanie MSB
 _delay_us(90);
 lcd_send_4bits(data); // wysyłanie LSB
 _delay_us(90); 
}

static inline void lcd_send_command(uint8_t cmd) // wysyłanie komend (poleceń)
{
 CLR_RS;
 lcd_send_8bits(cmd);
}

static inline void lcd_send_data(uint8_t data) // wysyłanie danych
{
 SET_RS;
 lcd_send_8bits(data);
}

void lcd_init(void)
{
 // Ustawienie DDR dla RS i E jako wyjścia
 LCD_PORT_DDR |= (1 << LCD_RS);
 LCD_PORT_DDR |= (1 << LCD_E);
 // Ustawienie DDR dla D4..D7 jako wyjścia
 LCD_PORT_DDR |= (1 << LCD_D4) | (1 << LCD_D5) | (1 << LCD_D6) | (1 << LCD_D7); 
 // Zerowanie pinów RS, E, D4, D5, D6, D7
 LCD_PORT &= ~(1 << LCD_RS);
 LCD_PORT &= ~(1 << LCD_E);
 LCD_PORT &= ~(1 << LCD_D4) & ~(1 << LCD_D5) & ~(1 << LCD_D6) & ~(1 << LCD_D7);
 _delay_ms(50); // czekanie po włączeniu zasilania
  lcd_send_4bits(0x03); // function set
 _delay_ms(4.1);
 lcd_send_4bits(0x03);
 _delay_us(100);
 lcd_send_4bits(0x03);
 _delay_us(100);
  lcd_send_4bits(0x02); // włączenie trybu 4-bitowego
 _delay_ms(3);
 //Od tego miejsca możemy wysyłać 8-bitów w porcjach po 4 bity
 //za pomocą funkcji lcd_send_command oraz lcd_send_data
 lcd_send_command(LCD_FUNCTION_SET); 
 _delay_us(100);
 lcd_send_command(0x08); // wyłączenie wyświetlacza
 _delay_us(100); 
 lcd_send_command(0x01); // wyczyszczenie wyświetlacza
 _delay_ms(3); 
 lcd_send_command(LCD_ENTRY_MODE); 
 _delay_us(100);
 lcd_send_command(LCD_DISPLAY_CONTROL); 
 _delay_us(100); 
#ifdef USE_PRINTF
 stdout = &lcd_stream;
#endif //USE_PRINTF
}
//czyszczenie całego ekranu
void lcd_clear (void) 
{
 lcd_send_command(0x01);  
 _delay_ms(2);
}
// powrót kursora do początku
void lcd_cursor_return(void) 
{
 lcd_send_command(0x02);  
 _delay_ms(2);
}

// wyświetlanie tekstu
void lcd_text(char* str)
{
 while (*str) lcd_send_data(*str++);
}

//ustawienie kursora w pozycji XY
void lcd_gotoXY(uint8_t x, uint8_t y) 
{
 #define LCD_LINE0 0x00
 #define LCD_LINE1 0x40
 #define LCD_LINE2 0x14
 #define LCD_LINE3 0x54
 uint8_t address = 0x00;
 if (y == 0) address = LCD_LINE0 + x; else
 if (y == 1) address = LCD_LINE1 + x; else
 if (y == 2) address = LCD_LINE2 + x; else
 if (y == 3) address = LCD_LINE3 + x;
 lcd_send_command( (1 << 7) | address); //ustawienie adresu DDRAM
 _delay_us(100);
} 

// ustawienia wyświetlacza i kursora
void lcd_display_control (uint8_t display, uint8_t cursor, uint8_t blink)
{
 uint8_t command = (1 << 3);
 if (display) command |= (1 << 2);
 if (cursor) command |= (1 << 1); 
 if (blink) command |= (1 << 0); 
 lcd_send_command(command);
 _delay_us(100);
}

// definiowanie własnego symbolu
void lcd_define_symbol (uint8_t code, uint8_t* def_char)
{
 lcd_send_command(64 + ((code & 0x07) * 8));
 for (uint8_t i = 0; i < 8; i++) lcd_send_data(def_char[i]);
 lcd_send_command(0x80);
 _delay_us(100);	
}

// wyświetlanie własnego symbolu
void lcd_symbol(uint8_t value)
{
 SET_RS;
 lcd_send_8bits(value);
 _delay_us(100);
}

// wyświetlanie liczb całkowitych
void lcd_integer (int16_t value)
{
 char buffer1[11]; 
 // liczba 10 oznacza system dzisiętny, 16 oznaczałoby heksadecymalny, a 2 binarny
 lcd_text(itoa (value,buffer1,10)); // dla int16 (od -32768 do +32767)
 //lcd_text(ltoa (value,buffer1,10)); // dla int32 (od -2147483647 do +2147483647)
}

// przesuwanie zawartości wyświetlacza
void lcd_shift_left(void)
{
  lcd_send_command(0x18); //24
  _delay_us(100);
}

// przesuwanie zawartości wyświetlacza
void lcd_shift_right(void)
{
  lcd_send_command(0x1C); //28
  _delay_us(100);
}

#ifdef USE_PRINTF
static int lcd_char(char c, FILE *stream)
{
 lcd_send_data(c);
 return 0;
}
#endif //USE_PRINTF

