import java.util.stream.Stream;

public class StreamDemo {
  public static void main(String[] args) {
    String[] names = {"Jan", "Piotr", "Sara", "Kasia", "Julia", 
      "Grzegorz", "Alan", "Sylwia", "Maria", "jan"};
    
    // Wyświetlanie 4 pierwszych imion po posortowaniu
    Stream.of(names).limit(4).sorted()
      .forEach(e -> System.out.print(e + " "));

    // Pomijanie 4 imion i wyświetlanie reszty posortowanej bez uwzględniania wielkości liter
    System.out.println();
    Stream.of(names).skip(4)
      .sorted((e1, e2) -> e1.compareToIgnoreCase(e2))
      .forEach(e -> System.out.print(e + " "));
    
    System.out.println();
    Stream.of(names).skip(4)
      .sorted(String::compareToIgnoreCase)
      .forEach(e -> System.out.print(e + " "));
    
    System.out.println("\nNajwiększy łańcuch znaków o długości > 4: "
      + Stream.of(names)
          .filter(e -> e.length() > 4)
          .max(String::compareTo).get());
    
    System.out.println("Najmniejszy łańcuch znaków alfabetycznie: "
      + Stream.of(names).min(String::compareTo).get());

    System.out.println("Sylwia należy do zbioru? "
      + Stream.of(names).anyMatch(e −> e.equals("Sylwia")));
    
    System.out.println("Wszystkie imiona zaczynają się wielką literą? "
      + Stream.of(names)
              .allMatch(e -> Character.isUpperCase(e.charAt(0))));

    System.out.println("Brak imion rozpoczynających się od Ko? "
      + Stream.of(names).noneMatch(e -> e.startsWith("Ko")));

    System.out.println("Liczba unikatowych imion (niezależnie od wielkości liter): "
      + Stream.of(names).map(e -> e.toUpperCase())
          .distinct().count());
        
    System.out.println("Pierwszy element rozpoczynający się małą literą: "
      + Stream.of(names).map(String::toLowerCase).findFirst().get());

    System.out.println("Pomiń 4 i pobierz dowolny element strumienia: "
      + Stream.of(names).skip(4).sorted().findAny().get());
    
    Object[] namesInLowerCase = 
      Stream.of(names).map(String::toLowerCase).toArray();
    System.out.println(java.util.Arrays.toString(namesInLowerCase));
  }
}
