import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.geometry.Insets;
import javafx.stage.Stage;
import javafx.scene.text.Text;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.FontPosture;

public class ShowText extends Application {
  @Override // Przesłanianie metody start w klasie Application
  public void start(Stage primaryStage) {
    // Tworzenie panelu do przechowywania tekstu
    Pane pane = new Pane();
    pane.setPadding(new Insets(5, 5, 5, 5));
    Text text1 = new Text(20, 20, "Programowanie to zabawa");
    text1.setFont(Font.font("Courier", FontWeight.BOLD, 
      FontPosture.ITALIC, 15));
    pane.getChildren().add(text1);     

    Text text2 = new Text(60, 60, "Programowanie to zabawa\nWyświetl tekst");
    pane.getChildren().add(text2);     

    Text text3 = new Text(10, 100, "Programowanie to zabawa\nWyświetl tekst");
    text3.setFill(Color.RED);
    text3.setUnderline(true); 
    text3.setStrikethrough(true); 
    pane.getChildren().add(text3); 
    
    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(pane);
    primaryStage.setTitle("ShowText"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }
  
  /**
* Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
