public interface Graph<V> {
  /** Zwraca liczbę wierzchołków w grafie */
  public int getSize();

  /** Zwraca wierzchołki grafu */
  public java.util.List<V> getVertices();

  /** Zwraca wierzchołek na podstawie indeksu */
  public V getVertex(int index);

  /** Zwraca indeks określonego wierzchołka */
  public int getIndex(V v);

  /** Zwraca sąsiadów wierzchołka o podanym indeksie */
  public java.util.List<Integer> getNeighbors(int index);

  /** Zwraca stopień określonego wierzchołka */
  public int getDegree(int v);

  /** Wyświetla krawędzie */
  public void printEdges();

  /** Opróżnia graf */
  public void clear();

  /** Dodaje wierzchołek do grafu */
  public boolean addVertex(V vertex);

  /** Dodaje krawędź do grafu */
  public boolean addEdge(int u, int v);

  /** Dodaje krawędź do grafu */  
  public boolean addEdge(Edge e);

  /** Usuwa z grafu wierzchołek v; po udanym wykonaniu operacji zwraca true */
  public boolean remove(V v);

  /** Usuwa z grafu krawędź (u, v); po udanym wykonaniu operacji zwraca true */
  public boolean remove(int u, int v);
  
  /** Generuje drzewo DFS */
  public UnweightedGraph<V>.SearchTree dfs(int v);

  /** Generuje drzewo BFS */
  public UnweightedGraph<V>.SearchTree bfs(int v);
}
