import java.io.File;
import java.util.Scanner; 

public class DirectorySize {
  public static void main(String[] args) {
    // Prośba o podanie katalogu lub pliku
    System.out.print("Podaj katalog lub plik: ");
    Scanner input = new Scanner(System.in);
    String directory = input.nextLine();
    
    // Wyświetlanie wielkości
    System.out.println(getSize(new File(directory)) + " (w bajtach)");
  }

  public static long getSize(File file) {
    long size = 0; // Przechowuje łączną wielkość wszystkich plików

    if (file.isDirectory()) {
      File[] files = file.listFiles(); // Wszystkie pliki i podkatalogi
      for (int i = 0; files != null && i < files.length; i++) {
        size += getSize(files[i]); // Wywołanie rekurencyjne
      }
    }
    else { // Przypadek bazowy
      size += file.length();
    }

    return size;
  }
}
