public class CircleWithException {
  /** Promień koła */
  private double radius;

  /** Liczba utworzonych obiektów */
  private static int numberOfObjects = 0;

  /** Tworzenie koła o promieniu 1 */
  public CircleWithException() {
    this(1.0);
  }

  /** Tworzenie koła o podanym promieniu */
  public CircleWithException(double newRadius) {
    setRadius(newRadius);
    numberOfObjects++;
  }

  /** Zwraca promień */
  public double getRadius() {
    return radius;
  }

  /** Ustawia nowy promień */
  public void setRadius(double newRadius)
      throws IllegalArgumentException {
    if (newRadius >= 0)
      radius = newRadius;
    else
      throw new IllegalArgumentException(
        "Promień nie może być ujemny");
  }

  /** Zwraca wartość numberOfObjects */
  public static int getNumberOfObjects() {
    return numberOfObjects;
  }

  /** Zwraca powierzchnię koła */
  public double findArea() {
    return radius * radius * 3.14159;
  }
}
