public class CircleWithRadiusException {
  /** Promień koła */
  private double radius;

  /** Liczba utworzonych obiektów */
  private static int numberOfObjects = 0;

  /** Tworzenie koła o promieniu 1 */
  public CircleWithRadiusException() {
    this(1.0);
  }

  /** Tworzenie koła o podanym promieniu */
  public CircleWithRadiusException(double newRadius) {
    try {
      setRadius(newRadius);
      numberOfObjects++;
    }
    catch (InvalidRadiusException ex) {
      ex.printStackTrace();
    }
  }

  /** Zwraca promień */
  public double getRadius() {
    return radius;
  }

  /** Ustawia nowy promień */
  public void setRadius(double newRadius)
      throws InvalidRadiusException {
    if (newRadius >= 0)
      radius =  newRadius;
    else
      throw new InvalidRadiusException(newRadius);
  }

  /** Zwraca wartość numberOfObjects */
  public static int getNumberOfObjects() {
    return numberOfObjects;
  }

  /** Zwraca powierzchnię koła */
  public double findArea() {
    return radius * radius * 3.14159;
  }
}

