import javafx.application.Application;
import javafx.stage.Stage;
import javafx.scene.Scene;

public class BounceBall extends Application {
  @Override // Przesanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    BallPane pane = new BallPane();

    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(pane, 250, 150);
    primaryStage.setTitle("BounceBall"); // Nagwek
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wywietlanie okna

    // Wstrzymywanie i wznawianie animacji
    pane.setOnMousePressed(e -> pane.pause());
    pane.setOnMouseReleased(e -> pane.play());

    pane.setFocusTraversable(true);
    pane.setOnKeyPressed(e -> {
      switch (e.getCode()) {
        case S:
          pane.decreaseSpeed();
          break;
        case F:
          pane.increaseSpeed();
          break;
      }
    });
  }

  /**
   * Metoda main jest potrzebna tylko w IDE z ograniczon obsug
   * JavaFX. Nie jest potrzebna przy uruchamianiu kodu w wierszu polece.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
