import java.io.*;

public class TestObjectStreamForArray {
  public static void main(String[] args)
      throws ClassNotFoundException, IOException {
    int[] numbers = {1, 2, 3, 4, 5};
    String[] strings = {"Jan", "Sara", "Kasia"};

    try ( // Tworzenie strumienia wyjściowego dla pliku array.dat
      ObjectOutputStream output = new ObjectOutputStream(new 
        FileOutputStream("array.dat", true));
    ) {
      // Zapis tablic w strumieniu wyjściowym
      output.writeObject(numbers);
      output.writeObject(strings);
    }

    try ( // Tworzenie strumienia wejściowego dla pliku array.dat
      ObjectInputStream input =
        new ObjectInputStream(new FileInputStream("array.dat"));
    ) {
      int[] newNumbers = (int[])(input.readObject());
      String[] newStrings = (String[])(input.readObject());
  
      // Wyświetlanie tablic
      for (int i = 0; i < newNumbers.length; i++)
        System.out.print(newNumbers[i] + " ");
      System.out.println();
  
      for (int i = 0; i < newStrings.length; i++)
        System.out.print(newStrings[i] + " ");
    }
  }
}
