public class TestBST {
  public static void main(String[] args) {
    // Tworzenie drzewa BST
    BST<String> tree = new BST<>();
    tree.insert("Grzegorz");
    tree.insert("Michał");
    tree.insert("Tomek");
    tree.insert("Adam");
    tree.insert("Jonasz");
    tree.insert("Piotr");
    tree.insert("Daniel");

    // Przechodzenie drzewa
    System.out.print("Inorder (posortowane): ");
    tree.inorder();
    System.out.print("\nPostorder: ");
    tree.postorder();
    System.out.print("\nPreorder: ");
    tree.preorder();
    System.out.print("\nLiczba węzłów: " + tree.getSize());

    // Wyszukiwanie elementu
    System.out.print("\nCzy Piotr występuje w drzewie? " +
      tree.search("Piotr"));

    // Pobieranie ścieżki z korzenia do elementu Piotr
    System.out.print("\nŚcieżka z korzenia do elementu Piotr: ");
    java.util.ArrayList<BST.TreeNode<String>> path 
      = tree.path("Piotr");
    for (int i = 0; path != null && i < path.size(); i++)
      System.out.print(path.get(i).element + " ");

    Integer[] numbers = {2, 4, 3, 1, 8, 5, 6, 7};
    BST<Integer> intTree = new BST<>(numbers); 
    System.out.print("\nInorder (posortowane): ");
    intTree.inorder();
  }
}
