import javafx.application.Application;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;

public class ShowGridPane extends Application {
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {
    // Tworzenie panelu i ustawianie jego właściwości
    GridPane pane = new GridPane();
    pane.setAlignment(Pos.CENTER); 
    pane.setPadding(new Insets(11.5, 12.5, 13.5, 14.5));
    pane.setHgap(5.5);
    pane.setVgap(5.5); 
    
    // Umieszczanie węzłów w panelu
    pane.add(new Label("Pierwsze imię:"), 0, 0);
    pane.add(new TextField(), 1, 0);
    pane.add(new Label("Inicjał:"), 0, 1); 
    pane.add(new TextField(), 1, 1);
    pane.add(new Label("Nazwisko:"), 0, 2);
    pane.add(new TextField(), 1, 2);
    Button btAdd = new Button("Dodaj");
    pane.add(btAdd, 1, 3);
    GridPane.setHalignment(btAdd, HPos.RIGHT);
    
    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(pane);
    primaryStage.setTitle("ShowGridPane"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }
  
  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
} 