import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

public class ShowBorderPane extends Application {
  @Override // Przesłania metodę start klasy Application
  public void start(Stage primaryStage) {
    // Tworzenie panelu BorderPane
    BorderPane pane = new BorderPane();

    // Umieszczanie węzłów w panelu
    pane.setTop(new CustomPane("Góra")); 
    pane.setRight(new CustomPane("Prawa"));
    pane.setBottom(new CustomPane("Dół"));
    pane.setLeft(new CustomPane("Lewa"));
    pane.setCenter(new CustomPane("Środek")); 
    
    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(pane);
    primaryStage.setTitle("ShowBorderPane"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }
} 

// Definiowanie niestandardowego panelu zawierającego pośrodku etykietę
class CustomPane extends StackPane {
  public CustomPane(String title) {
    getChildren().add(new Label(title));
    setStyle("-fx-border-color: red");
    setPadding(new Insets(11.5, 12.5, 13.5, 14.5));
  }
}