import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.Group;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.text.Text;

public class ShowArc extends Application {
  @Override // Przesłanianie metody start z klasy Application
  public void start(Stage primaryStage) {   
    Arc arc1 = new Arc(150, 100, 80, 80, 30, 35); // Tworzenie łuku
    arc1.setFill(Color.RED); // Określanie koloru wypełnienia
    arc1.setType(ArcType.ROUND); // Określanie rodzaju łuku
    
    Arc arc2 = new Arc(150, 100, 80, 80, 30 + 90, 35);
    arc2.setFill(Color.WHITE);
    arc2.setType(ArcType.OPEN);
    arc2.setStroke(Color.BLACK);

    Arc arc3 = new Arc(150, 100, 80, 80, 30 + 180, 35);
    arc3.setFill(Color.WHITE);
    arc3.setType(ArcType.CHORD);
    arc3.setStroke(Color.BLACK);
    
    Arc arc4 = new Arc(150, 100, 80, 80, 30 + 270, 35);
    arc4.setFill(Color.GREEN);
    arc4.setType(ArcType.CHORD);
    arc4.setStroke(Color.BLACK);
    
    // Tworzenie grupy i dodawanie do niej węzłów
    Group group = new Group();
    group.getChildren().addAll(new Text(210, 40, "arc1: round"), 
      arc1, new Text(20, 40, "arc2: open"), arc2,
      new Text(20, 170, "arc3: chord"), arc3, 
      new Text(210, 170, "arc4: chord"), arc4);      

    // Tworzenie sceny i umieszczanie jej w oknie
    Scene scene = new Scene(new BorderPane(group), 300, 200);
    primaryStage.setTitle("ShowArc"); // Ustawianie nagłówka okna
    primaryStage.setScene(scene); // Umieszczanie sceny w oknie
    primaryStage.show(); // Wyświetlanie okna
  }
  
  /**
   * Metoda main jest potrzebna tylko w środowiskach IDE z ograniczoną obsługą platformy JavaFX.
   * Nie jest potrzebna przy uruchamianiu kodu w wierszu poleceń.
   */
  public static void main(String[] args) {
    launch(args);
  }
}
