import java.io.*;
import java.util.*;

public class ReplaceText {
  public static void main(String[] args) throws Exception {
    // Sprawdzanie parametrów z wiersza poleceń
    if (args.length != 4) {
      System.out.println(
        "Użytkowanie: java ReplaceText plikŹród plikDocel dawnyTekst nowyTekst");
      System.exit(1);
    }

    // Sprawdzanie, czy plik źródłowy istnieje
    File sourceFile = new File(args[0]);
    if (!sourceFile.exists()) {
      System.out.println("Plik źródłowy " + args[0] + " nie istnieje");
      System.exit(2);
    }

    // Sprawdzanie, czy plik docelowy istnieje
    File targetFile = new File(args[1]);
    if (targetFile.exists()) {
      System.out.println("Plik docelowy " + args[1] + " już istnieje");
      System.exit(3);
    }

    try (
      // Tworzenie obiektów dla plików wejściowego i wyjściowego
      Scanner input = new Scanner(sourceFile);
      PrintWriter output = new PrintWriter(targetFile);
    ) {        
      while (input.hasNext()) {
        String s1 = input.nextLine();
        String s2 = s1.replaceAll(args[2], args[3]);
        output.println(s2);
      }
    }
  }
}
