import java.io.File;
import java.nio.file.Files;
import java.util.Scanner;

public class DirectorySizeStream {
  public static void main(String[] args) throws Exception {
    // Wyświetlanie prośby o podanie katalogu lub pliku
    System.out.print("Podaj katalog lub plik: ");
    Scanner input = new Scanner(System.in);
    String directory = input.nextLine();

    // Wyświetlanie wielkości katalogu
    System.out.println(getSize(new File(directory)) + " (w bajtach)");
  }

  public static long getSize(File file) {
    if (file.isFile()) {
      return file.length();
    } 
    else {
      try {
        return Files.list(file.toPath()).parallel().
          mapToLong(e -> getSize(e.toFile())).sum();
      } catch (Exception ex) {
        return 0; 
      }
    }
  }
}
