import java.io.*;

public class Copy {
  /** Metoda main
     @param args[0] plik źródłowy
     @param args[1] plik docelowy
   */
  public static void main(String[] args) throws IOException { 
    // Sprawdzanie parametrów z wiersza poleceń
    if (args.length != 2) { 
      System.out.println(
        "Użytkowanie: java Copy plikŹródłowy plikDocelowy");
      System.exit(1);
    }

    // Sprawdzanie, czy plik źródłowy istnieje
    File sourceFile = new File(args[0]);
    if (!sourceFile.exists()) {
       System.out.println("Plik źródłowy " + args[0]
         + " nie istnieje");
       System.exit(2);
    }

    // Sprawdzanie, czy plik docelowy istnieje
    File targetFile = new File(args[1]);
    if (targetFile.exists()) {
      System.out.println("Plik docelowy " + args[1]
        + " już istnieje");
      System.exit(3);
    }

    try (
      // Tworzenie strumienia wejściowego
      BufferedInputStream input = 
        new BufferedInputStream(new FileInputStream(sourceFile));
  
      // Tworzenie strumienia wyjściowego
      BufferedOutputStream output = 
        new BufferedOutputStream(new FileOutputStream(targetFile));
    ) {
      // Cykliczne wczytywanie bajta z wejścia i zapisywanie go w wyjściu
      int r, numberOfBytesCopied = 0;
      while ((r = input.read()) != -1) {
        output.write((byte)r);
        numberOfBytesCopied++;
      }

      // Wyświetlanie wielkości pliku
      System.out.println("Liczba skopiowanych bajtów: " + numberOfBytesCopied);
    }
  }
}
